﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using System;
using Microsoft.Xna.Framework;
using GE.World.Entities;

namespace GE.Physics.Shapes
{
    abstract class ShapeRectangle : Shape
    {
        /// <summary>
        /// Rectangle's width
        /// </summary>
        protected int _iWidth;

        /// <summary>
        /// Rectangle's height
        /// </summary>
        protected int _iHeight;

        /// <summary>
        /// Point used as origin to apply rotation.
        /// </summary>
        protected Vector2 _v2RotationCenter;

        /// <summary>
        /// Return the width of the rectangle
        /// </summary>
        public int Width { get { return _iWidth; } }

        /// <summary>
        /// Return the origin of the rectangle
        /// </summary>
        public Vector2 Center { get { return _v2RotationCenter; } }

        public ShapeRectangle(): base()
        {
            _typeOfShape = eTypeShape.eRectangleShape;
            _iWidth = 0;
            _iHeight = 0;
            _v2RotationCenter = Vector2.Zero;
            _bCollisionEnable = true;
            _iGroup = -1;
        }

        public ShapeRectangle(int width, int height, Vector2 rotationCenter, WorldEntity owner)
        {
            _typeOfShape = eTypeShape.eRectangleShape;
            _iWidth = width;
            _iHeight = height;
            _v2RotationCenter = rotationCenter;
            _refToOwner = owner;
            _bCollisionEnable = true;
            _iGroup = -1;
        }

        public ShapeRectangle(int width, int height, Vector2 rotationCenter, Vector2 position, float orientation, WorldEntity owner)
            :this(width, height, rotationCenter, owner)
        {
            _v2position = position;
            _fOrientation = orientation;
        }

        public abstract Vector2[] getOrientedBoundingBox();

        public virtual void resize(int w, int h) { }
    }
}
